// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QBLUETOOTHDEVICEINFO_P_H
#define QBLUETOOTHDEVICEINFO_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qbluetoothdeviceinfo.h"
#include "qbluetoothaddress.h"
#include "qbluetoothuuid.h"

#include <QString>
#include <QtCore/qhash.h>
#include <QtCore/private/qglobal_p.h>

QT_BEGIN_NAMESPACE

class QBluetoothDeviceInfoPrivate
{
public:
    QBluetoothDeviceInfoPrivate();

    bool valid = false;
    bool cached = false;
    qint16 rssi = 1;
    quint8 minorDeviceClass = 0;

    QBluetoothAddress address;
    QString name;
    QBluetoothDeviceInfo::MajorDeviceClass majorDeviceClass = QBluetoothDeviceInfo::MiscellaneousDevice;

    QBluetoothDeviceInfo::ServiceClasses serviceClasses = QBluetoothDeviceInfo::NoService;

    QList<QBluetoothUuid> serviceUuids;
    QMultiHash<quint16, QByteArray> manufacturerData;
    QMultiHash<QBluetoothUuid, QByteArray> serviceData;
    QBluetoothDeviceInfo::CoreConfigurations deviceCoreConfiguration = QBluetoothDeviceInfo::UnknownCoreConfiguration;

    QBluetoothUuid deviceUuid;
};

QT_END_NAMESPACE

#endif
